package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.SeccionesDao;
import com.ejie.ab04b.model.Secciones;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * SeccionesServiceImpl generated by UDA, 27-jul-2016 11:29:27.
 * 
 * @author UDA
 */

@Service(value = "seccionesService")
public class SeccionesServiceImpl implements SeccionesService {

	@Autowired()
	private SeccionesDao seccionesDao;

	/**
	 * Inserts a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the secciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Secciones add(Secciones secciones) {
		return this.seccionesDao.add(secciones);
	}

	/**
	 * Updates a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the secciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Secciones update(Secciones secciones) {
		return this.seccionesDao.update(secciones);
	}

	/**
	 * Finds a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  Secciones
	 *
	 * @param secciones the secciones
	 * @return the secciones
	 */
	public Secciones find(Secciones secciones) {
		return (Secciones) this.seccionesDao.find(secciones);
	}

	/**
	 * Deletes a single row in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *
	 * @param secciones the secciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Secciones secciones) {
		this.seccionesDao.remove(secciones);
	}

	/**
	 * Finds a list of rows in the Secciones table.
	 * 
	 *  secciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Secciones>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Secciones> findAll(Secciones secciones,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Secciones>) this.seccionesDao.findAll(secciones,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Secciones table using like.
	 * 
	 *  secciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Secciones>
	 *
	 * @param secciones the secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Secciones> findAllLike(Secciones secciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Secciones>) this.seccionesDao.findAllLike(secciones,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Secciones table.
	 * 
	 *  filterSecciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Secciones>
	 *
	 * @param filterSecciones the filter secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Secciones> filter(Secciones filterSecciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Secciones> listaSecciones = this.seccionesDao.findAllLike(
				filterSecciones, jqGridRequestDto, false);
		Long recordNum = this.seccionesDao.findAllLikeCount(
				filterSecciones != null ? filterSecciones : new Secciones(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Secciones>> reorderSelection = this.seccionesDao
					.reorderSelection(filterSecciones, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Secciones>(jqGridRequestDto,
					recordNum, listaSecciones, reorderSelection);
		}
		return new JQGridResponseDto<Secciones>(jqGridRequestDto, recordNum,
				listaSecciones);
	}

	/**
	 * Reorder the selection made in Secciones table.
	 * 
	 *  filterSecciones
	 *            Secciones
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterSecciones the filter secciones
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Secciones filterSecciones,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.seccionesDao.reorderSelection(filterSecciones,
				jqGridRequestDto, startsWith);
	}

}
